/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class ModifierLayer<T extends IAnimation>
implements IAnimation {
    private final List<AbstractModifier> modifiers = new ArrayList<AbstractModifier>();
    @Nullable
    T animation;

    public ModifierLayer(@Nullable T animation, AbstractModifier ... modifiers) {
        this.animation = animation;
        Collections.addAll(this.modifiers, modifiers);
    }

    public ModifierLayer() {
        this(null, new AbstractModifier[0]);
    }

    @Override
    public void tick() {
        for (int i = 0; i < this.modifiers.size(); ++i) {
            if (!this.modifiers.get(i).canRemove()) continue;
            this.removeModifier(i--);
        }
        if (this.modifiers.size() > 0) {
            this.modifiers.get(0).tick();
        } else if (this.animation != null) {
            this.animation.tick();
        }
    }

    public void addModifier(AbstractModifier modifier, int idx) {
        modifier.setHost(this);
        this.modifiers.add(idx, modifier);
        this.linkModifiers();
    }

    public void addModifierBefore(AbstractModifier modifier) {
        this.addModifier(modifier, 0);
    }

    public void addModifierLast(AbstractModifier modifier) {
        this.addModifier(modifier, this.modifiers.size());
    }

    public void removeModifier(int idx) {
        this.modifiers.remove(idx);
        this.linkModifiers();
    }

    public void setAnimation(@Nullable T animation) {
        this.animation = animation;
        this.linkModifiers();
    }

    public void replaceAnimationWithFade(AbstractFadeModifier fadeModifier, @Nullable T newAnimation) {
        this.replaceAnimationWithFade(fadeModifier, newAnimation, false);
    }

    public void replaceAnimationWithFade(AbstractFadeModifier fadeModifier, @Nullable T newAnimation, boolean fadeFromNothing) {
        if (fadeFromNothing || this.getAnimation() != null && this.getAnimation().isActive()) {
            fadeModifier.setBeginAnimation((IAnimation)this.getAnimation());
            this.addModifierLast(fadeModifier);
        }
        this.setAnimation(newAnimation);
    }

    public int size() {
        return this.modifiers.size();
    }

    protected void linkModifiers() {
        Iterator<AbstractModifier> modifierIterator = this.modifiers.iterator();
        if (modifierIterator.hasNext()) {
            AbstractModifier tmp = modifierIterator.next();
            while (modifierIterator.hasNext()) {
                AbstractModifier tmp2 = modifierIterator.next();
                tmp.setAnim(tmp2);
                tmp = tmp2;
            }
            tmp.setAnim(this.animation);
        }
    }

    @Override
    public boolean isActive() {
        if (this.modifiers.size() > 0) {
            return this.modifiers.get(0).isActive();
        }
        if (this.animation != null) {
            return this.animation.isActive();
        }
        return false;
    }

    @Override
    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        if (this.modifiers.size() > 0) {
            return this.modifiers.get(0).get3DTransform(modelName, type, tickDelta, value0);
        }
        if (this.animation != null) {
            return this.animation.get3DTransform(modelName, type, tickDelta, value0);
        }
        return value0;
    }

    @Override
    public void setupAnim(float tickDelta) {
        if (this.modifiers.size() > 0) {
            this.modifiers.get(0).setupAnim(tickDelta);
        } else if (this.animation != null) {
            this.animation.setupAnim(tickDelta);
        }
    }

    @Nullable
    public T getAnimation() {
        return this.animation;
    }
}

